/*
 *  Meals5.cpp
 *
 */

#include <iostream>
#include <string>

using namespace std;  //introduces namespace std

// Base meal class
class Meal
{
public:
  Meal():mainDish(""){}
  Meal(string argMainDish):mainDish(argMainDish){}
  Meal &operator=(Meal &m)
  {
    cout << "In Meal::operator=" << endl;
    mainDish = m.getMainDish();
    return *this;
  }
  
  virtual void setMainDish(string argMainDish)
  {
    mainDish = argMainDish;
  }
  
  virtual void printMenu();
  
  string getMainDish()
  {
    return mainDish; 
  }
private:
  string mainDish;
};

// Virutal member to print menu
void Meal::printMenu()
{
  cout << "we will be having " << mainDish << endl;
}


// DERIVED Breakfast class
// NOW WITH A VIRTUAL BASE CLASS!!
class Breakfast : virtual public Meal
{
public:
  Breakfast():Meal(){}
  Breakfast(string argMainDish):Meal(argMainDish){}
  
  Breakfast &operator=(Breakfast &b)
  {
    // Make sure base class copy is called
    Meal::operator=(b);
    cout << "In Breakfast::operator= " << endl;
    return *this;
  }
  
  virtual void printMenu();

};

void Breakfast::printMenu()
{
  cout << "For BREAKFAST, ";
  Meal::printMenu();
}


// DERIVED Lunch class
// NOW WITH A VIRTUAL BASE CLASS!!
class Lunch : virtual public Meal
{
public:
  Lunch():Meal(){}
  Lunch(string argMainDish):Meal(argMainDish){}
  
  Lunch &operator=(Lunch &l)
  {
    // Make sure base class operator is called
    Meal::operator=(l);
    cout << "In Lunch::operator= " << endl;
    return *this;
  }
   virtual void printMenu();

};

void Lunch::printMenu()
{
  cout << "For LUNCH, ";
  Meal::printMenu();
}


// MULTIPLY DERIVED Brunch class
class Brunch : public Breakfast, public Lunch
{
public:
  Brunch():Meal(){}
  Brunch(string argMainDish):Meal(argMainDish){}
  
  Brunch &operator=(Brunch &b)
  {
    Breakfast::operator=(b);
    Lunch::operator=(b);
    cout << "In Brunch::operator= " << endl;
    return *this;
  }
  virtual void printMenu();

};

void Brunch::printMenu()
{
  cout << "For BRUNCH, ";
  Meal::printMenu();
}

int main()
{	
  Brunch aBrunch("Scrambled Eggs");
  Brunch anotherBrunch;
  
  cout << "About to copy..." << endl;
  anotherBrunch = aBrunch;
//  aBrunch.printMenu();
  return 0;
}

